// FilePlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FilePlayer.h"
#include "FilePlayerDlg.h"
#include <iostream>
#include <fstream>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

BOOL on_process_file_video_decoder_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	return TRUE; 
}

BOOL on_process_file_audio_decoder_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	return TRUE; 
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilePlayerDlg dialog

CFilePlayerDlg::CFilePlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFilePlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilePlayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_nVideoColorSpaceType = MAKEFOURCC('H', '2', '6', '4');

	m_dVideoFrameRate = 0.0;

	m_nAudioStreamType = 0;
	
	m_nAVFileTotalDurationTimes = 0;

	m_nAVFileTotalVideoFrames = 0;

	m_nAVFileTotalAudioFrames = 0;

	m_nAVFileState = 0x00000000;
}

void CFilePlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilePlayerDlg)
	DDX_Control(pDX, IDC_PROGRESS_TIME, m_progTimeBar);
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_editFilePath);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFilePlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CFilePlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_PLAY, OnButtonPlay)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE, OnButtonPause)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_PLUS, OnButtonSpeedPlus)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_MINUS, OnButtonSpeedMinus)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_ANALYSIS, OnButtonAnalysis)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

// CFilePlayerDlg message handlers

extern CFilePlayerApp theApp;

BOOL CFilePlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

//	m_editFilePath.SetWindowText( theApp.GetProfileString( "DEFAULT", "FILE.PATH", "" ) );	

	m_editFilePath.SetWindowText( "" );	

	m_pFile = NULL;

	m_nVideoFormat = 0;

	m_nVideoWidth = 0;

	m_nVideoHeight = 0;

	m_dVideoFrameRate = 0;

	m_nAudioChannels = 0;

	m_nAudioBitsPerSample = 0;

	m_nAudioSampleFrequency = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFilePlayerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	SC_DEBUG( "FilePlayer::Destroy()" );

	// DESTROY FILE RESOURCE
	//
	if( m_nAVFileState > 0x00000000 ) {

		if( m_pFile == 0xFFFFFFFF ) { return; }

		BOOL returns = AMESDK_STOP( m_pFile );

		if( returns == FALSE ) { return; }

		returns = AMESDK_PAUSE( m_pFile );

		if( returns == FALSE ) { return; }

		returns = AMESDK_FILE_SET_MEDIA_POSITION( m_pFile, 0, 0x00000000 );

		if( returns == FALSE ) { return; }

		m_nAVFileState = 0x00000000;
	}

	if( m_pFile ) {

		AMESDK_STOP( m_pFile );

		AMESDK_DESTROY( m_pFile );

		m_pFile = NULL;
	}

	m_nVideoColorSpaceType = MAKEFOURCC('H', '2', '6', '4');

	m_dVideoFrameRate = 0.0;

	m_nAudioStreamType = 0;
	
	m_nAVFileTotalDurationTimes = 0;

	m_nAVFileTotalVideoFrames = 0;

	m_nAVFileTotalAudioFrames = 0;

	m_nAVFileState = 0x00000000;

	CString strFilePath;

	m_editFilePath.GetWindowText( strFilePath );

	m_progTimeBar.SetRange( 0, 200 );

//	theApp.WriteProfileString( "DEFAULT", "FILE.PATH", (LPCTSTR)(strFilePath) );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CFilePlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFilePlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFilePlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFilePlayerDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CFilePlayerDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}


void CFilePlayerDlg::OnButtonOpen() 
{
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "AVI;MP4\0*.AVI;*.MP4\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			AMESDK_STOP( m_pFile );

			AMESDK_DESTROY( m_pFile );

			m_pFile = NULL;
		}
		//
		// CHECK WINDOWS SYSTEM
		//
		BOOL is_enable_enhanced_video_renderer = FALSE;

		OSVERSIONINFO s_os_version_info;

		memset( &s_os_version_info, 0x00, sizeof(s_os_version_info) );

		s_os_version_info.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

		GetVersionEx( &s_os_version_info );

		if( s_os_version_info.dwMajorVersion >= 6 &&

			s_os_version_info.dwMinorVersion >= 1 ) { // IT IS WIN7

			is_enable_enhanced_video_renderer = TRUE;
		}

		CHAR* pszFileName = m_strFilePath.GetBuffer( m_strFilePath.GetLength() );

		HWND hAttachedWindow = m_statWindow.m_hWnd;

		BOOL bThumbDraw = TRUE;

		BOOL bMaintainAspectRatio = FALSE;

		// CREATE FILE SOURCE RESOURCE
		//
		{	CHAR psz[ MAX_PATH ];

			sprintf( psz, "Common Analog File Source %s", pszFileName );

			m_pFile = AMESDK_CREATE_EX( psz, 0, 2, 

										hAttachedWindow, on_process_file_video_decoder_buffer, 0, is_enable_enhanced_video_renderer, bMaintainAspectRatio, this, 

										hAttachedWindow, on_process_file_audio_decoder_buffer, 0, is_enable_enhanced_video_renderer, bMaintainAspectRatio, this );
			
			if( m_pFile == 0x80000001 ) { 
				
				m_pFile = 0xFFFFFFFF; 
				
				return ;
			}
		}
		m_strFilePath.ReleaseBuffer();

		if( m_pFile & 0x80000000 ) {

			m_pFile = 0xFFFFFFFF;

			SC_DEBUG( "FilePlayer::Create() FAIL!!" );

			return;
		}
		AMESDK_FILE_GET_VIDEO_STREAM_FORMAT( m_pFile, &m_nVideoColorSpaceType, &m_nVideoWidth, &m_nVideoHeight, NULL, &m_dVideoFrameRate, NULL );

		AMESDK_FILE_GET_AUDIO_STREAM_FORMAT( m_pFile, &m_nAudioStreamType, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency );

		AMESDK_FILE_GET_MEDIA_LENGTH( m_pFile, &m_nAVFileTotalDurationTimes, 0x00000000 );

		AMESDK_FILE_GET_MEDIA_LENGTH( m_pFile, &m_nAVFileTotalVideoFrames, 0x00000001 );

		AMESDK_FILE_GET_MEDIA_LENGTH( m_pFile, &m_nAVFileTotalAudioFrames, 0x00000002 );
		
		if( m_nVideoFormat ) { 
			
			if( m_nVideoColorSpaceType == MAKEFOURCC('H', '2', '6', '4') ) {

				m_nVideoFormat = 0;
			}
			else {

				m_nVideoFormat = 0;
			}
		}

		AMESDK_PAUSE( m_pFile );

		AMESDK_FILE_SET_MEDIA_POSITION( m_pFile, 0, 0x00000000 );

		m_nAVFileState = 0x00000000;

		SC_DEBUG( "FilePlayer::Create() SUCCESS!!" );

		/////////////////////////////////////////////////////////////////////////////////

		double speed = 0;

		if( m_pFile == 0xFFFFFFFF ) { return; }

		LONGLONG position = 0;

		BOOL returns = AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_pFile, &speed );

		if( returns == FALSE ) { return; }

		CHAR psz_info[ 512 ];

		CString vfmt;

		CString afmt;

		if( m_nVideoFormat == 0 ) { vfmt = "H264"; }

		if( m_nAudioStreamType == 0 ) { afmt = "PCM"; }

		if( m_nAudioStreamType == 1 ) { afmt = "AAC RAW"; }

		if( m_nAudioStreamType == 2 ) { afmt = "AAC ADTS"; }

		sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, (m_nAVFileTotalDurationTimes / 10000000.0), (ULONG)(m_nAVFileTotalVideoFrames), (ULONG)(m_nAVFileTotalAudioFrames), vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

		m_editFilePath.SetWindowText( psz_info );

		SetTimer( 0x00000000, 10, NULL );
	}
	else {

		return ;
	}
}

void CFilePlayerDlg::OnButtonPlay() 
{
	// TODO: Add your control notification handler code here

	double dSampleTime = 0;

	if( m_pFile == 0xFFFFFFFF ) { return; }

	LONGLONG position = 0;

	BOOL returns = AMESDK_FILE_GET_MEDIA_POSITION( m_pFile, &position, 0x00000000 );

	if( returns == FALSE ) { return; }

	dSampleTime = position / 10000000.0;

	if( dSampleTime >= (m_nAVFileTotalDurationTimes / 10000000.0) ) {

		if( m_pFile == 0xFFFFFFFF ) { return; }

		BOOL returns = AMESDK_STOP( m_pFile );

		if( returns == FALSE ) { return; }

		returns = AMESDK_PAUSE( m_pFile );

		if( returns == FALSE ) { return; }

		returns = AMESDK_FILE_SET_MEDIA_POSITION( m_pFile, 0, 0x00000000 );

		if( returns == FALSE ) { return; }

		m_nAVFileState = 0x00000000;
	}

	if( m_pFile == 0xFFFFFFFF ) { return; }

	returns = AMESDK_RUN( m_pFile );

	if( returns == FALSE ) { return; }

	m_nAVFileState = 0x00000001;
}

void CFilePlayerDlg::OnButtonPause() 
{
	// TODO: Add your control notification handler code here

	if( m_pFile == 0xFFFFFFFF ) { return; }

	BOOL returns = AMESDK_PAUSE( m_pFile );

	if( returns == FALSE ) { return; }

	m_nAVFileState = 0x00000000;
}

void CFilePlayerDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	if( m_pFile == 0xFFFFFFFF ) { return; }

	BOOL returns = AMESDK_STOP( m_pFile );

	if( returns == FALSE ) { return; }

	returns = AMESDK_PAUSE( m_pFile );

	if( returns == FALSE ) { return; }

	returns = AMESDK_FILE_SET_MEDIA_POSITION( m_pFile, 0, 0x00000000 );

	if( returns == FALSE ) { return; }

	m_nAVFileState = 0x00000000;
}

void CFilePlayerDlg::OnButtonSpeedPlus() 
{
	// TODO: Add your control notification handler code here
	
	double speed = 0;

	if( m_pFile == 0xFFFFFFFF ) { return; }

	BOOL returns = AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_pFile, &speed );

	if( returns == FALSE ) { return; }
	
	speed += 0.25;

	if( m_pFile == 0xFFFFFFFF ) { return; }

	returns = AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE( m_pFile, speed );

	if( returns == FALSE ) { return; }

	if( m_pFile == 0xFFFFFFFF ) { return; }

	returns = AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_pFile, &speed );

	if( returns == FALSE ) { return; }

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == 0 ) { vfmt = "H264"; }

	if( m_nAudioStreamType == 0 ) { afmt = "PCM"; }

	if( m_nAudioStreamType == 1 ) { afmt = "AAC RAW"; }

	if( m_nAudioStreamType == 2 ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, (m_nAVFileTotalDurationTimes / 10000000.0), (ULONG)(m_nAVFileTotalVideoFrames), (ULONG)(m_nAVFileTotalAudioFrames), vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	m_editFilePath.SetWindowText( psz_info );	
}

void CFilePlayerDlg::OnButtonSpeedMinus() 
{
	// TODO: Add your control notification handler code here
	
	double speed = 0;

	if( m_pFile == 0xFFFFFFFF ) { return; }

	BOOL returns = AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_pFile, &speed );

	if( returns == FALSE ) { return; }

	speed -= 0.25;

	if( m_pFile == 0xFFFFFFFF ) { return; }

	returns = AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE( m_pFile, speed );

	if( returns == FALSE ) { return; }

	if( m_pFile == 0xFFFFFFFF ) { return; }

	returns = AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_pFile, &speed );

	if( returns == FALSE ) { return; }

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == 0 ) { vfmt = "H264"; }

	if( m_nAudioStreamType == 0 ) { afmt = "PCM"; }

	if( m_nAudioStreamType == 1 ) { afmt = "AAC RAW"; }

	if( m_nAudioStreamType == 2 ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, (m_nAVFileTotalDurationTimes / 10000000.0), (ULONG)(m_nAVFileTotalVideoFrames), (ULONG)(m_nAVFileTotalAudioFrames), vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	m_editFilePath.SetWindowText( psz_info );	
}

void CFilePlayerDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {		

		if( m_pFile == 0xFFFFFFFF ) { return; }

		LONGLONG position = 0;

		BOOL returns = AMESDK_FILE_GET_MEDIA_POSITION( m_pFile, &position, 0x00000000 );

		if( returns == FALSE ) { return; }

		double dSampleTime = position / 10000000.0;

		m_progTimeBar.SetPos( (int)(100.0 * (dSampleTime / (m_nAVFileTotalDurationTimes / 10000000.0))) );
	}
	CDialog::OnTimer(nIDEvent);
}

void CFilePlayerDlg::OnButtonAnalysis() 
{
}
